/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.util.BFBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class InfusedCandleBlock
extends BaseEntityBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;
    public static boolean canBeLit;

    public InfusedCandleBlock(BlockBehaviour.Properties settings) {
        super(settings);
        canBeLit = InfusedCandleBlock.canBeLit(this.m_49966_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_41619_() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            InfusedCandleBlock.extinguish(player, state, (LevelAccessor)world, pos);
            return InteractionResult.SUCCESS;
        }
        if ((player.m_21120_(hand).m_150930_(Items.f_42409_) || player.m_21120_(hand).m_150930_(Items.f_42613_)) && !InfusedCandleBlock.canBeLit(state)) {
            return InteractionResult.FAIL;
        }
        if (player.m_21120_(hand).m_150930_(Items.f_42409_)) {
            InfusedCandleBlock.setLit((LevelAccessor)world, state, pos, true);
            world.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.4f + 0.8f);
            player.m_21120_(hand).m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(hand).m_150930_(Items.f_42613_)) {
            InfusedCandleBlock.setLit((LevelAccessor)world, state, pos, true);
            world.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.2f + 1.0f);
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, LIT});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return null;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5581_(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!world.f_46443_ && projectile.m_6060_() && !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            InfusedCandleBlock.setLit((LevelAccessor)world, state, hit.m_82425_(), true);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return Block.m_49863_((LevelReader)world, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public static void extinguish(@Nullable Player player, BlockState state, LevelAccessor world, BlockPos pos) {
        InfusedCandleBlock.setLit(world, state, pos, false);
        world.m_5594_(null, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
        world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        boolean bl = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return;
        }
        InfusedCandleBlock.spawnCandleParticles(world, new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5), random);
    }

    public static boolean canBeLit(BlockState state) {
        return state.m_204338_(BFBlockTags.INFUSED_CANDLES, statex -> statex.m_61138_((Property)LIT) && statex.m_61138_((Property)WATERLOGGED)) && (Boolean)state.m_61143_((Property)LIT) == false && (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    static void setLit(LevelAccessor world, BlockState state, BlockPos pos, boolean lit) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(lit)), 11);
    }

    private static void spawnCandleParticles(Level world, Vec3 vec3d, RandomSource random) {
        float f = random.m_188501_();
        if (f < 0.3f) {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                world.m_7785_(vec3d.f_82479_ + 0.5, vec3d.f_82480_ + 0.5, vec3d.f_82481_ + 0.5, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + random.m_188501_(), random.m_188501_() * 0.7f + 0.3f, false);
            }
        }
        world.m_7106_((ParticleOptions)ParticleTypes.f_175834_, vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 0.0, 0.0, 0.0);
    }

    public BooleanProperty getLit() {
        return LIT;
    }
}

